/* A tiny program to record speech times
   (Mini-Programm zur Sprechzeiterfassung)
   compile with "gcc -l curses"
   2006-09-10
   Vlado Plaga
*/

#include <stdio.h>
#include <stdlib.h>     /* for malloc */
#include <time.h>
#include <curses.h>      /* for unbuffered input */

struct speaker {
  char name[20];       /* To identify the speakers */
  time_t talkTime;     /* Total time spoken */
  time_t utteranceBegin; /* when the current utterance began (only set if speaking) */
  char nowSpeaking;    /* 0 = false, 1 = true */
  int utterances;      /* Number of utterances */
  struct speaker *next;
};

void initscreen(){
  initscr();
  cbreak();
  noecho();
  nonl();
  keypad(stdscr,TRUE);
};


int displaySpeakers(struct speaker *curSpeaker){
  int i = 0;
  int totalTalkTime = 0;
  struct speaker *tmpSpeaker = curSpeaker;

  while (tmpSpeaker != NULL){
    totalTalkTime += tmpSpeaker->talkTime;
    tmpSpeaker=tmpSpeaker->next;
  }
  clear();
  move(0,0);
  printw("\n =================================== \n");

  printw("\nTotal time spoken: %d:%d\n\n", totalTalkTime / 60, totalTalkTime % 60);

  while (curSpeaker != NULL){
    i++;
    printw( "(%d) %s   (%d utterances) - Time spoken: %d:%d (%d %%) %s\n\n", i, curSpeaker->name, curSpeaker->utterances, curSpeaker->talkTime / 60, curSpeaker->talkTime % 60, (totalTalkTime > 0 ? (curSpeaker->talkTime * 100 / totalTalkTime): 0), (curSpeaker->nowSpeaking > 0 ? "<---" : "") );
    curSpeaker=curSpeaker->next;
  }
  return 0;
}

struct speaker *initSpeaker(char number){
  struct speaker *thisSpeaker;
  thisSpeaker = (struct speaker *) malloc (sizeof(struct speaker));
  printf("Enter the name of speaker %d: ", number);
  fgets(thisSpeaker->name, 20, stdin);
  thisSpeaker->talkTime = 0;
  thisSpeaker->nowSpeaking = 0;
  thisSpeaker->utterances = 0;
  thisSpeaker->next = NULL;
  return thisSpeaker;
}

int main(){
  int speakers = 3;
  char i;
  char c;
  char number_pressed;
  time_t lesson_start, total_time;


  printf("\nHow many speakers to you want to observe (1 - 9)? ");
  scanf("%d", &speakers);
  fflush(stdin); /* delete remaining characters from stdin */
  c = getchar(); /* catch the last \n */

  if ((speakers > 0) && (speakers < 10)){ /* needn't do anything if the number of speakers is wrong */

    struct speaker *firstSpeaker = initSpeaker(1);
    struct speaker *curSpeaker = firstSpeaker;

    /* initialise speakers: */
    for (i = 2; i <= speakers; i++){
      if (i == speakers) printf("Time mesuring will begin after you've entered the last name!\n");
      curSpeaker->next = initSpeaker(i);
      curSpeaker = curSpeaker->next;
    }
    initscreen();
    printw("Time measuring begins now...");
    lesson_start = time(0);

    do
    {
      displaySpeakers(firstSpeaker);
      c = getch();
      number_pressed = c - 48;
      if (number_pressed <= speakers){
        curSpeaker = firstSpeaker;
        for (i = 1; i < number_pressed; i++)
          curSpeaker = curSpeaker->next;
        if (curSpeaker->nowSpeaking){  /* When a speaker ends an utterance */
          curSpeaker->talkTime = curSpeaker->talkTime + (time(0) - curSpeaker->utteranceBegin);
        }
        else{
          curSpeaker->utteranceBegin = time(0); /* save time when utterance begins */
          curSpeaker->utterances++;
        }
        curSpeaker->nowSpeaking = !curSpeaker->nowSpeaking;
      }
      if (c == 113){
        total_time = time(0) - lesson_start;
        printw( "Total time: %d:%d\n", total_time / 60, total_time % 60 );
        printw( "\nPress 'q' again to quit or any other key to continue.\n" );
        c = getch();
      }
    }
    while ( c != 113 ); /* 113 is ASCII for "q" */
    endwin();
  } /* The part that is only executed if we have the right number of speakers */
  return 0;
}
